﻿var contextProperties = {
    context: null,
    useADAuthentication: null,
    ADDomain: null,
    initialize: function (context) {
        contextProperties.context = context;
        contextProperties.useADAuthentication = $("input[name=UseADAuthentication]:radio:checked", context).val() == "True";
        contextProperties.ADDomain = $("#ADDomain", context).val();

        $("#ClientName", context).a4autocomplete({
            ajaxAction: a4.getAction("GetNotSynchronizedClients", "MultiMode", "Admin"),
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#ClientId", context),
            select: function (event, data) {
                if (data && data.item) {
                    $("#DisableRespondentIpPersistence", context).prop("checked", data.item.DisableRespondentIpPersistence);
                    $("#CustomSurveyEngineURL", context).val(data.item.CustomSurveyEngineURL);

                    var useADAuthentication = contextProperties.useADAuthentication || data.item.UseADAuthentication;

                    $("#UseADAuthentication[Value='True']", context).prop("checked", useADAuthentication);
                    $("#UseADAuthentication[Value='False']", context).prop("checked", !useADAuthentication);
                    $("#ADDomain", context).val(contextProperties.ADDomain || data.item.ADDomain);
                }
                else {
                    $("#DisableRespondentIpPersistence", context).prop("checked", false);
                    $("#CustomSurveyEngineURL", context).val("");

                    $("#UseADAuthentication[Value='True']", context).prop("checked", contextProperties.useADAuthentication);
                    $("#UseADAuthentication[Value='False']", context).prop("checked", !contextProperties.useADAuthentication);
                    $("#ADDomain", context).val(contextProperties.ADDomain);
                }
            }
        });

        contextProperties.bindEvents();
    },
    bindEvents: function () {
        $("input[name=UseADAuthentication]:radio", contextProperties.context).on("change", function () {
            var useAD = $(this).val().toLowerCase() == "true";

            if (!useAD) {
                $("#ADDomain", contextProperties.context).val("");
            }
        });

        $(":radio[name='CreateNewClient']", contextProperties.context).on("change", function () {
            $(".v-clientNameSection", contextProperties.context).toggle($(this).val() == "False");
        });
    }
}

$(document).ready(function () {
    if ($(".v-contextProperties").length > 0) {
        a4.busyBoxEnabled = true;
        contextProperties.initialize($(".v-contextProperties"));
    }
});